/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.DungeonBeast;
import OreSpawn.entities.Fairy;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Irukandji;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.Skate;
import OreSpawn.entities.Vortex;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Urchin
extends EntityLiving {
    public Urchin(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 2.75f;
        this.width = 1.25f;
        this.uniquename = "OreSpawn:Urchin";
        this.moveSpeed = 0.22f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 22.0f;
        this.attackRange = 2.5f;
        this.movefrequency = 45;
        this.setExperience(49);
        this.canSwim = false;
        this.isImmuneToFire = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        victim.setOnFire(20);
        super.doAttack(victim);
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:kyuubi_living";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(5);
        if (which == 0) {
            return "OreSpawn:glasshit1";
        }
        if (which == 1) {
            return "OreSpawn:glasshit2";
        }
        if (which == 2) {
            return "OreSpawn:glasshit3";
        }
        if (which == 3) {
            return "OreSpawn:glasshit4";
        }
        return "OreSpawn:glasshit5";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(2);
        if (which == 0) {
            return "OreSpawn:glassdead1";
        }
        return "OreSpawn:glassdead2";
    }

    public void doDeathDrops() {
        int howmany = this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fireball.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pink.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pinkboots.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pinkleggings.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pinkchestplate.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pinkhelmet.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crystalpinkaxe.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crystalpinkpickaxe.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crystalpinkshovel.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crystalpinksword.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crystalpinkhoe.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyurchin.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public void update(float deltaT) {
        if (!this.world.isServer) {
            if (this.world.rand.nextInt(20) == 1) {
                Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleFire", (int)2, (int)this.dimension, (double)this.posx, (double)(this.posy + 1.0), (double)this.posz, (boolean)false);
            }
            if (this.world.rand.nextInt(20) == 1) {
                Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleSmoke", (int)2, (int)this.dimension, (double)this.posx, (double)(this.posy + 1.0), (double)this.posz, (boolean)false);
            }
        }
        super.update(deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Urchin) {
            return false;
        }
        if (e instanceof Rotator) {
            return false;
        }
        if (e instanceof Vortex) {
            return false;
        }
        if (e instanceof DungeonBeast) {
            return false;
        }
        if (e instanceof Skate) {
            return false;
        }
        if (e instanceof Irukandji) {
            return false;
        }
        if (e instanceof Fairy && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Girlfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Urchintexture.png");
        }
        return this.texture;
    }
}

